<?php

namespace App\Http\Controllers;

use App\Models\BranchM;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BranchMController extends Controller
{
    public function index()
    {
        return response()->json(BranchM::with(['coMaster', 'parties'])->get(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'br_df' => 'nullable|string|max:1',
            'br_nm' => 'nullable|string|max:35',
            'br_ad_pr_no' => 'nullable|string|max:10',
            'br_ad_pr_nm' => 'nullable|string|max:45',
            'br_ad_nr_lm' => 'nullable|string|max:45',
            'br_ad_strt' => 'nullable|string|max:45',
            'br_ad_area' => 'nullable|string|max:20',
            'br_ad_city' => 'nullable|string|max:20',
            'br_ad_stat' => 'nullable|string|max:20',
            'br_ad_pin_c' => 'nullable|string|max:7',
            'br_ph' => 'nullable|string|max:35',
            'br_s_rt' => 'required|string|max:20',
            'br_p_rt' => 'nullable|string|max:20',
            'tallydata' => 'nullable|string|max:50',
            'tallydata1' => 'nullable|string|max:50',
            't_port' => 'nullable|string|max:5',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'dept_id' => 'nullable|string|max:50',
            'br_grp' => 'nullable|string|max:4',
            'br_coll_name' => 'nullable|string|max:50',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $branchM = BranchM::create($request->all());
        return response()->json($branchM->load(['coMaster', 'parties']), 201);
    }

    public function show($id)
    {
        $branchM = BranchM::with(['coMaster', 'parties'])->findOrFail($id);
        return response()->json($branchM, 200);
    }

    public function update(Request $request, $id)
    {
        $branchM = BranchM::findOrFail($id);
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'br_df' => 'nullable|string|max:1',
            'br_nm' => 'nullable|string|max:35',
            'br_ad_pr_no' => 'nullable|string|max:10',
            'br_ad_pr_nm' => 'nullable|string|max:45',
            'br_ad_nr_lm' => 'nullable|string|max:45',
            'br_ad_strt' => 'nullable|string|max:45',
            'br_ad_area' => 'nullable|string|max:20',
            'br_ad_city' => 'nullable|string|max:20',
            'br_ad_stat' => 'nullable|string|max:20',
            'br_ad_pin_c' => 'nullable|string|max:7',
            'br_ph' => 'nullable|string|max:35',
            'br_s_rt' => 'required|string|max:20',
            'br_p_rt' => 'nullable|string|max:20',
            'tallydata' => 'nullable|string|max:50',
            'tallydata1' => 'nullable|string|max:50',
            't_port' => 'nullable|string|max:5',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'dept_id' => 'nullable|string|max:50',
            'br_grp' => 'nullable|string|max:4',
            'br_coll_name' => 'nullable|string|max:50',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $branchM->update($request->all());
        return response()->json($branchM->load(['coMaster', 'parties']), 200);
    }

    public function destroy($id)
    {
        $branchM = BranchM::findOrFail($id);
        $branchM->delete();
        return response()->json(null, 204);
    }
}
