<?php

namespace App\Http\Controllers;

use App\Models\GrAuthorityMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class GrAuthorityMasterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $authorities = GrAuthorityMaster::where('is_active', true)->get();

        return response()->json([
            'success' => true,
            'message' => 'Grant authorities retrieved successfully',
            'data' => $authorities
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:100',
            'code' => 'required|string|max:50|unique:gr_authority_masters,code',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation errors',
                'errors' => $validator->errors()
            ], 422);
        }

        $authority = GrAuthorityMaster::create([
            'name' => $request->name,
            'code' => $request->code,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Grant authority created successfully',
            'data' => $authority
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $authority = GrAuthorityMaster::find($id);

        if (!$authority) {
            return response()->json([
                'success' => false,
                'message' => 'Grant authority not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'message' => 'Grant authority retrieved successfully',
            'data' => $authority
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $authority = GrAuthorityMaster::find($id);

        if (!$authority) {
            return response()->json([
                'success' => false,
                'message' => 'Grant authority not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:100',
            'code' => 'required|string|max:50|unique:gr_authority_masters,code,' . $id . ',gr_au_id',
            'is_active' => 'boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation errors',
                'errors' => $validator->errors()
            ], 422);
        }

        $authority->update($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Grant authority updated successfully',
            'data' => $authority
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $authority = GrAuthorityMaster::find($id);

        if (!$authority) {
            return response()->json([
                'success' => false,
                'message' => 'Grant authority not found'
            ], 404);
        }

        // Soft delete by marking as inactive
        $authority->update(['is_active' => false]);

        return response()->json([
            'success' => true,
            'message' => 'Grant authority deactivated successfully'
        ]);
    }

    /**
     * Restore the specified resource.
     */
    public function restore($id)
    {
        $authority = GrAuthorityMaster::find($id);

        if (!$authority) {
            return response()->json([
                'success' => false,
                'message' => 'Grant authority not found'
            ], 404);
        }

        $authority->update(['is_active' => true]);

        return response()->json([
            'success' => true,
            'message' => 'Grant authority activated successfully',
            'data' => $authority
        ]);
    }

    /**
     * Get all authorities (including inactive)
     */
    public function getAll()
    {
        $authorities = GrAuthorityMaster::all();

        return response()->json([
            'success' => true,
            'message' => 'All grant authorities retrieved successfully',
            'data' => $authorities
        ]);
    }
}
