<?php

namespace App\Http\Controllers;

use App\Models\RecognizedBy;
use Illuminate\Http\Request;

class RecognizedByController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $recognizedBies = RecognizedBy::all();
        return response()->json($recognizedBies);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'code' => 'nullable|string|unique:recognized_bies|max:50',
            'name' => 'required|string|max:255'
        ]);

        $recognizedBy = RecognizedBy::create($request->all());
        return response()->json($recognizedBy, 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $recognizedBy = RecognizedBy::find($id);

        if (!$recognizedBy) {
            return response()->json(['message' => 'Recognized By not found'], 404);
        }

        return response()->json($recognizedBy);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $recognizedBy = RecognizedBy::find($id);

        if (!$recognizedBy) {
            return response()->json(['message' => 'Recognized By not found'], 404);
        }

        $request->validate([
            'code' => 'nullable|string|max:50|unique:recognized_bies,code,' . $id,
            'name' => 'required|string|max:255'
        ]);

        $recognizedBy->update($request->all());
        return response()->json($recognizedBy);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $recognizedBy = RecognizedBy::find($id);

        if (!$recognizedBy) {
            return response()->json(['message' => 'Recognized By not found'], 404);
        }

        $recognizedBy->delete();
        return response()->json(['message' => 'Recognized By deleted successfully']);
    }
}
