<?php

namespace App\Http\Controllers;

use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class StatusController extends Controller
{
    // List all statuses
    public function index()
    {
        return response()->json(
            Status::orderBy('status_id', 'desc')->get(),
            200
        );
    }

    // Store new status
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'status_type' => 'nullable|string'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }

        $status = Status::create($request->all());

        return response()->json([
            'message' => 'Status created successfully',
            'data' => $status
        ], 201);
    }

    // Show single status
    public function show($id)
    {
        $status = Status::find($id);

        if (!$status) {
            return response()->json(['message' => 'Status not found'], 404);
        }

        return response()->json($status, 200);
    }

    // Update status
    public function update(Request $request, $id)
    {
        $status = Status::find($id);

        if (!$status) {
            return response()->json(['message' => 'Status not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'status_type' => 'nullable|string'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }

        $status->update($request->all());

        return response()->json([
            'message' => 'Status updated successfully',
            'data' => $status
        ], 200);
    }

    // Delete status
    public function destroy($id)
    {
        $status = Status::find($id);

        if (!$status) {
            return response()->json(['message' => 'Status not found'], 404);
        }

        $status->delete();

        return response()->json(['message' => 'Status deleted successfully'], 200);
    }
}
