<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\TenderPenelty;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TenderPeneltyController extends Controller
{


public function index()
{
    $data = TenderPenelty::with([
        'subLedger',
        'tenderAllocation.tenderEntry',
        'tenderAllocation.tenderEntry.department',
        'tenderAllocation.tenderEntry.ledger'
    ])
    ->orderBy('tp_id', 'desc')
    ->get();

    return response()->json($data, 200);
}


    public function store(Request $request)
    {
        $data = TenderPenelty::create($request->all());
        return response()->json([
            'message' => 'Record created successfully',
            'data' => $data
        ], 201);
    }

public function show($id)
{
    $data = TenderPenelty::with([
        'subLedger',
        'tenderAllocation.tenderEntry',
        'tenderAllocation.tenderEntry.department',
        'tenderAllocation.tenderEntry.ledger'
    ])->find($id);

    if (!$data) {
        return response()->json(['message' => 'Record not found'], 404);
    }

    return response()->json($data, 200);
}


    public function update(Request $request, $id)
    {
        $data = TenderPenelty::find($id);

        if (!$data) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $data->update($request->all());

        return response()->json([
            'message' => 'Record updated successfully',
            'data' => $data
        ], 200);
    }

    public function destroy($id)
    {
        $data = TenderPenelty::find($id);

        if (!$data) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $data->delete();

        return response()->json(['message' => 'Record deleted successfully'], 200);
    }
}
