<?php

namespace App\Http\Controllers;

use App\Models\UserDepartmentMapping;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class UserDepartmentMappingController extends Controller
{
    // LIST WITH USER + DEPARTMENT
    public function index()
    {
        $data = UserDepartmentMapping::with(['user','department'])->get();

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }

    // CREATE
public function store(Request $request)
{
    $validator = Validator::make($request->all(), [
        'user_id' => 'required|integer|exists:gmc_users,user_id',
        'Dept_Id' => 'required|integer|exists:main_departments,id',
        'Status' => 'nullable|boolean'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status' => false,
            'errors' => $validator->errors()
        ], 422);
    }

    $data = UserDepartmentMapping::create([
        'user_id' => $request->user_id,
        'Dept_Id' => $request->Dept_Id,
        'Status' => $request->Status ?? 1
    ]);

    return response()->json([
        'status' => true,
        'message' => 'Mapping created',
        'data' => UserDepartmentMapping::with(['user','department'])
                    ->find($data->User_Dept_map_Id)
    ]);
}


    // VIEW SINGLE WITH RELATIONS
    public function show($id)
    {
        $data = UserDepartmentMapping::with(['user','department'])->find($id);

        if (!$data) {
            return response()->json([
                'status'=>false,
                'message'=>'Not found'
            ],404);
        }

        return response()->json([
            'status'=>true,
            'data'=>$data
        ]);
    }

    // UPDATE
public function update(Request $request, $id)
{
    $data = UserDepartmentMapping::find($id);

    if (!$data) {
        return response()->json([
            'status'=>false,
            'message'=>'Not found'
        ],404);
    }

    $validator = Validator::make($request->all(), [
        'user_id' => 'nullable|integer|exists:gmc_users,user_id',
        'Dept_Id' => 'nullable|integer|exists:main_departments,id',
        'Status' => 'nullable|boolean'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status'=>false,
            'errors'=>$validator->errors()
        ],422);
    }

    $data->update($request->only([
        'user_id',
        'Dept_Id',
        'Status'
    ]));

    return response()->json([
        'status'=>true,
        'message'=>'Updated successfully',
        'data'=> UserDepartmentMapping::with(['user','department'])
                    ->find($id)
    ]);
}


    // DELETE
    public function destroy($id)
    {
        $data = UserDepartmentMapping::find($id);

        if (!$data) {
            return response()->json([
                'status'=>false,
                'message'=>'Not found'
            ],404);
        }

        $data->delete();

        return response()->json([
            'status'=>true,
            'message'=>'Deleted successfully'
        ]);
    }
}
