<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\GmcUserSession;
use Symfony\Component\HttpFoundation\Response;

class GmcAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json([
                'success' => false,
                'message' => 'Authentication token required'
            ], 401);
        }

        $session = GmcUserSession::where('session_token', $token)
            ->where('is_active', true)
            ->where('expires_at', '>', now())
            ->first();

        if (!$session) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid or expired session'
            ], 401);
        }

        // Update last activity
        $session->update(['last_activity' => now()]);

        // Extend session if about to expire (within 5 minutes)
        if ($session->expires_at->diffInMinutes(now()) < 5) {
            $session->update([
                'expires_at' => now()->addMinutes($session->user->session_timeout)
            ]);
        }

        // Authenticate user
        auth()->login($session->user);

        return $next($request);
    }
}
