<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CoMaster extends Model
{
    use HasFactory;

    protected $table = 'co_masters';
    protected $primaryKey = 'Co_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'co_grp',
        'co_nam',
        'co_ad1',
        'co_ad2',
        'co_cty',
        'co_pin',
        'co_phn',
        'co_eml',
        'co_url',
        'co_pan',
        'co_tds',
        'co_pac',
        'co_tdc',
        'co_lic',
        'co_reg',
        'co_st_n',
        'co_cst',
        'co_vat',
        'co_ecc',
        'co_exc',
        'co_rng',
        'tr_mod',
        'co_bak',
        'co_ent',
        'co_typ',
        'CoFin',
        'lst_bk',
        'bs_typ',
        'co_qty',
        'co_pss',
        'op_id',
        'dt_tm',
        'logo',
        'dept_id',
    ];

    protected $casts = [
        'co_bak' => 'decimal:0',
        'co_qty' => 'decimal:0',
        'lst_bk' => 'datetime',
        'CoFin' => 'integer',
    ];

    // Relationships
    public function branches()
    {
        return $this->hasMany(BranchM::class, 'Co_Id', 'Co_Id');
    }

    public function ledgerGroups()
    {
        return $this->hasMany(LedgGrp::class, 'Co_Id', 'Co_Id');
    }

    public function parties()
    {
        return $this->hasMany(PrtyMast::class, 'Co_Id', 'Co_Id');
    }
}
