<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DAMaster extends Model
{
    use HasFactory;
    protected $table = 'da_masters';   // ✅ FIX

    protected $primaryKey = 'da_id';

    protected $fillable = [
        'da_sr',
        'fr_date',
        'to_date',
        'eff_date',
        'commission_id',
        'da_rate',
        'da_paid',
        'da_diff',
        'npa_rate',
        'npa_limit',
        'dapf',
        'bon_limit',
        'ir_rate',
        'da_diff_mon',
        'da_diff_rate'
    ];

    // ✅ FK relation
    public function commission()
    {
        return $this->belongsTo(
            PayCommissionMaster::class,
            'commission_id',
            'commission_id'
        );
    }
}
