<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DesPostBook extends Model
{
    use HasFactory;

    protected $table = 'des_post_books';
    protected $primaryKey = 'dp_id';

    protected $fillable = [
        'dp_date',
        'designation_id',
        'per_post',
        'temp_post'
    ];

    public function designationMenu()
    {
        return $this->belongsTo(
            DesignationMenu::class,
            'designation_id',
            'id'
        );
    }
}
