<?php
// app/Models/DesignationPayMapping.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DesignationPayMapping extends Model
{
    use HasFactory;

    protected $primaryKey = 'mapping_id';

    protected $fillable = [
        'designation_id',
        'commission_id',
        'structure_type_id',
        'pay_scale_id',
        'pay_band_id',
        'grade_pay_id',
        'level_id'
    ];

    public function designation()
    {
        return $this->belongsTo(DesignationMaster::class, 'designation_id');
    }

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'commission_id');
    }

    public function structureType()
    {
        return $this->belongsTo(PayStructureTypeMaster::class, 'structure_type_id');
    }

    public function payScale()
    {
        return $this->belongsTo(PayScaleMaster::class, 'pay_scale_id');
    }

    public function payBand()
    {
        return $this->belongsTo(PayBandMaster::class, 'pay_band_id');
    }

    public function gradePay()
    {
        return $this->belongsTo(GradePayMaster::class, 'grade_pay_id');
    }

    public function level()
    {
        return $this->belongsTo(PayMatrixLevelMaster::class, 'level_id');
    }
}
