<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\GmcUser;

class DeviceApprovalLog extends Model
{
    protected $table = 'gmc_device_approval_logs';
    protected $primaryKey = 'log_id';
    public $timestamps = false;

    protected $fillable = [
        'queue_id',
        'approval_id',
        'user_id',
        'action_type',
        'action_details',
        'device_data',
        'performed_by',
        'ip_address',
        'user_agent',
        'performed_at'
    ];

    protected $casts = [
        'device_data' => 'array',
        'performed_at' => 'datetime'
    ];


    public function user()
    {
         return $this->belongsTo(GmcUser::class, 'user_id', 'user_id');
    }
}
