<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FamilyInfoMaster extends Model
{
    use HasFactory;

    protected $table = 'family_info_master';
    protected $primaryKey = 'family_id';

    protected $fillable = [
        'emp_id',
        'member_name',
        'gender',
        'relation_id',
        'dob',
        'mob_num',
        'is_active',
    ];

    // ✅ UPDATE: emp_id should be integer, not string
    protected $casts = [
        'emp_id' => 'integer', // ✅ Change to integer
        'relation_id' => 'integer',
        'dob' => 'date:Y-m-d',
        'mob_num' => 'string',
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Relationship with Employee
     */
    public function employee()
    {
        return $this->belongsTo(EmployeeMaster::class, 'emp_id', 'emp_id');
    }

    /**
     * Relationship with RelationshipMaster
     */
    public function relationship()
    {
        return $this->belongsTo(RelationshipMaster::class, 'relation_id', 'relation_id');
    }

    /**
     * Scope for filtering by employee
     */
    public function scopeByEmployee($query, $empId)
    {
        return $query->where('emp_id', $empId);
    }

    /**
     * Scope for filtering by gender
     */
    public function scopeByGender($query, $gender)
    {
        return $query->where('gender', $gender);
    }
}
