<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FasFundsTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'fas_funds_type_master';
    protected $primaryKey = 'funds_type_id';

    protected $fillable = [
        'funds_code',
        'funds_name',
        'fund_type',           // Added new field
        'source_of_fund',      // Added new field
        'grant_category_id',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'grant_category_id' => 'integer',
        'created_at' => 'datetime'
    ];

    /**
     * Relationship with GrantCategoryMaster
     */
    public function grantCategory()
    {
        return $this->belongsTo(GrantCategoryMaster::class, 'grant_category_id', 'id');
    }
}
