<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FasGrantTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'fas_grant_type_master';
    protected $primaryKey = 'grant_type_id';

    protected $fillable = [
        'grant_code',
        'grant_name',
        'gt_nature',
        'gt_condition',
        'gt_util_from_date',
        'gt_util_to_date',
        'gt_act_mode',
        'gt_status',
        'gr_au_id',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'gt_util_from_date' => 'date',
        'gt_util_to_date' => 'date',
        'gr_au_id' => 'integer'
    ];

    // Relationship with GrAuthorityMaster
    public function grantAuthority()
    {
        return $this->belongsTo(GrAuthorityMaster::class, 'gr_au_id', 'gr_au_id');
    }

    // Relationship with GrantDivisionMapping
    public function departmentMappings()
    {
        return $this->hasMany(GrantDivisionMapping::class, 'grant_ty_id', 'grant_type_id');
    }
}
