<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FasLoanDocumentMaster extends Model
{
    use HasFactory;

    protected $table = 'fas_loan_document_master';
    protected $primaryKey = 'doc_id';

    protected $fillable = [
        'doc_code',
        'doc_name',
        'loan_type_id',
        'is_mandatory',
        'is_active'
    ];

    // 🔹 Relationship to LoanTypeMaster
    public function loanType()
    {
        return $this->belongsTo(FasLoanTypeMaster::class, 'loan_type_id', 'loan_type_id');
    }
}
