<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FasLoanTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'fas_loan_type_master';
    protected $primaryKey = 'loan_type_id';

    protected $fillable = [
        'loan_code',
        'loan_name',
        'max_amount',
        'loan_mode',
        'interest_rate',
        'tenure_years',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'max_amount' => 'decimal:2',
        'interest_rate' => 'decimal:2',
        'tenure_years' => 'integer',
        'created_at' => 'datetime'
    ];
}
