<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class FinanTrn extends Model
{
    use HasFactory;

    protected $table = 'finan_trns';
    protected $primaryKey = 'Ft_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Org_Id',
        'Lg_Id',
        'vou_ty',
        'vou_id',
        'vou_sr',
        'vou_ln',
        'v_mode',
        'vou_rf',
        'vou_dt',
        'inq_id',
        'ag_id',
        'inst_no',
        'agt_amt',
        'cr_amt',
        'dr_amt',
        'ref_id', // Will be foreign key to LedgerMaster
        'chq_no',
        'chq_dt',
        'clr_dt',
        'bk_id',
        'lot_no',
        'rmk1',
        'rmk2',
        'rmk3',
        'rmk4',
        'rmk5',
        'chq_mode',
        'r_mode',
        'sms_stus',
        'email_stus',
        'sm_id',
        'an_id',
        'bfr1',
        'bfr2',
        'op_id',
        'dt_tm',
        'pay_mode',
        'exp_ref',
    ];

    protected $casts = [
        'vou_dt' => 'datetime',
        'chq_dt' => 'datetime',
        'clr_dt' => 'datetime',
        'inq_id' => 'decimal:0',
        'agt_amt' => 'decimal:4',
        'cr_amt' => 'decimal:2',
        'dr_amt' => 'decimal:2',
        'ref_id' => 'integer', // Changed from decimal to integer for FK
        'lot_no' => 'decimal:0',
    ];

    public function getVouDtAttribute($value)
    {
        if ($value) {
            return Carbon::parse($value)->timezone('Asia/Kolkata')->format('d/m/Y');
        }
        return null;
    }

    // Relationships
    public function organisation()
    {
        return $this->belongsTo(OrganisationSetting::class, 'Org_Id', 'Org_Id');
    }

    public function ledger()
    {
        return $this->belongsTo(LedgerMaster::class, 'Lg_Id', 'Lg_Id');
    }

    // New relationship for ref_id (linked to LedgerMaster)
    public function refLedger()
    {
        return $this->belongsTo(LedgerMaster::class, 'ref_id', 'Lg_Id');
    }

    public function agent()
{
    return $this->belongsTo(SubLedgerMaster::class, 'ag_id', 'SL_Id');
}

}
