<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FunctionType extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',        // ✅ added
        'department_id', // ✅ ADD

        'desc',
        'category_id',
        'Upgrp',
        'Grcod',
        'Grsrn',
        'Grsh',
        'isvisible', // Added new field
        'func_id',
        'Menu_Links',
    ];

    // Cast the fields to appropriate types
    protected $casts = [
        'title'       => 'string',   // ✅ added
        'department_id' => 'integer', // ✅ ADD

        'Grsrn' => 'string',
        'Grsh' => 'string',
        'isvisible' => 'integer', // Added cast
        'func_id' => 'integer',
        'category_id' => 'integer',
        'Menu_Links' => 'string',
    ];

    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'department_id', 'id');
    }

    // Scope for active items
    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    // Scope for inactive items
    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }

    // Accessor for isvisible
    public function getIsVisibleAttribute()
    {
        return $this->attributes['isvisible'] == 1 ? 'Active' : 'Inactive';
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'category_id');
    }

    public function parentFunctionType()
    {
        return $this->belongsTo(FunctionType::class, 'func_id');
    }

    public function childFunctionTypes()
    {
        return $this->hasMany(FunctionType::class, 'func_id');
    }
}
