<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FunctionTypesTwo extends Model
{
    use HasFactory;

    protected $table = 'functiontypestwo';

    protected $fillable = [
        'title',
        'desc',
        'Menu_Links',
        'Upgrp',
        'Grcod',
        'Grsrn',
        'Grsh',
        'isvisible'
    ];

    protected $casts = [
        'title'      => 'string',
        'desc'       => 'string',
        'Menu_Links' => 'string',
        'Upgrp'      => 'string',
        'Grcod'      => 'string',
        'Grsrn'      => 'string',
        'Grsh'       => 'string',
        'isvisible'  => 'integer', // 🔥 VERY IMPORTANT

    ];

    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }
}
