<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GmcUserActivityLog extends Model
{
    use HasFactory;

    protected $table = 'gmc_user_activity_log';
    protected $primaryKey = 'activity_id';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'session_id',
        'device_approval_id',
        'module_name',
        'page_url',
        'page_title',
        'action_type',
        'action_element',
        'action_value',
        'mouse_x',
        'mouse_y',
        'scroll_position',
        'key_pressed',
        'form_data',
        'load_time_ms',
        'response_time_ms',
        'error_code',
        'error_message',
        'error_stack',
        'device_fingerprint',
        'ip_address',
        'user_agent',
        'mac_address',
        'device_match_status',
        'activity_timestamp'
    ];

    protected $casts = [
        'form_data' => 'array',
        'mouse_x' => 'integer',
        'mouse_y' => 'integer',
        'scroll_position' => 'integer',
        'load_time_ms' => 'integer',
        'response_time_ms' => 'integer',
        'activity_timestamp' => 'datetime'
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(GmcUser::class, 'user_id');
    }

    public function session()
    {
        return $this->belongsTo(GmcUserSession::class, 'session_id');
    }

    public function deviceApproval()
    {
        return $this->belongsTo(GmcDeviceApproval::class, 'device_approval_id');
    }
}
