<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
// Remove SoftDeletes trait
// use Illuminate\Database\Eloquent\SoftDeletes;

class GrAuthorityMaster extends Model
{
    use HasFactory; // Remove SoftDeletes from here

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'gr_au_id';

    /**
     * Indicates if the IDs are auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = true;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'code',
        'is_active'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'gr_authority_masters';

    /**
     * Get the grant types for this authority
     */
    public function grantTypes()
    {
        return $this->hasMany(FasGrantTypeMaster::class, 'gr_au_id', 'gr_au_id');
    }
}
