<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InquiryMaster extends Model
{
    use HasFactory;

    protected $table = 'inquiry_master';
    protected $primaryKey = 'inquiry_id';

    protected $fillable = [
        'inquiry_no',
        'citizen_name',
        'mobile',
        'subject',
        'inquiry_type',
        'department_id', // Foreign key for main_departments
        'status'
    ];

    // Relationship with MainDepartment (not Department)
    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'department_id', 'id');
    }
}
