<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MainDepartment extends Model
{
    use HasFactory;

    protected $table = 'main_departments';
        protected $primaryKey = 'id';

    protected $fillable = [
        'desc',
        'category_id',
        'Upgrp',
        'Grcod',
        'Grsm',
        'Grsh',
        'isvisible',
        'func_id',
        'Menu_Links',
    ];

    // Cast the fields to appropriate types
    protected $casts = [
        'Grsh' => 'string',
        'Grsm' => 'string',
        'isvisible' => 'integer',
        'func_id' => 'integer',
        'category_id' => 'integer',
        'Menu_Links' => 'string',
    ];

    // Scope for active items
    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    // Scope for inactive items
    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }

    // Accessor for isvisible
    public function getIsVisibleAttribute()
    {
        return $this->attributes['isvisible'] == 1 ? 'Active' : 'Inactive';
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'category_id');
    }

    public function parentDepartment()
    {
        return $this->belongsTo(MainDepartment::class, 'func_id');
    }

    public function childDepartments()
    {
        return $this->hasMany(MainDepartment::class, 'func_id');
    }
    // Add this to MainDepartment model
    public function grantDivisionMappings()
    {
        return $this->hasMany(GrantDivisionMapping::class, 'dept_ids', 'id');
    }
}
