<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Module extends Model
{
    protected $table = 'modules';

    protected $fillable = [
        'id',
        'module_name',
        'description',
        'is_superadmin'
    ];

    protected $casts = [
        'is_superadmin' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function permissions()
    {
        return $this->hasMany(Permission::class, 'module_id');
    }
}
