<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NewTenderWork extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'new_tender_works';
    protected $primaryKey = 'tend_work_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'work_code',
        'work_name'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    // Add relationship to VendorInvoiceParameter
    public function vendorInvoiceParameters()
    {
        return $this->hasMany(VendorInvoiceParameter::class, 'tend_work_id', 'tend_work_id');
    }
}
