<?php

namespace App\Models;

use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrganisationSetting extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'organisation_settings';
    protected $primaryKey = 'Org_Id';

    protected $fillable = [
        'Org_Name',
        'Org_Code',
        'Org_GST_No',
        'Org_TDS_No',
        'Org_PAN_No',
        'Org_Address',
        'Org_City',
        'Org_State',
        'Org_Pin',
        'Org_Email',
        'Org_Mobile',
        'Org_URL',
        'Org_Logo'
    ];

    protected $casts = [
        'Org_Id' => 'integer'
    ];

    // Accessor: Always return full URL
    public function getOrgLogoAttribute($value)
    {
        return $value ? asset('storage/' . $value) : null;
    }

    // Validation rules for CREATE
    public static function createRules()
    {
        return [
            'Org_Name' => 'required|string|max:255',
            'Org_Code' => 'nullable|string|max:25|unique:organisation_settings,Org_Code',
            'Org_GST_No' => 'nullable|string|max:50|unique:organisation_settings,Org_GST_No',
            'Org_TDS_No' => 'nullable|string|max:50',
            'Org_PAN_No' => 'nullable|string|max:50|unique:organisation_settings,Org_PAN_No',
            'Org_Address' => 'nullable|string',
            'Org_City' => 'nullable|string|max:100',
            'Org_State' => 'nullable|string|max:100',
            'Org_Pin' => 'nullable|string|max:10',
            'Org_Email' => 'nullable|email|max:100',
            'Org_Mobile' => 'nullable|string|max:20',
            'Org_URL' => 'nullable|url|max:255',
            'Org_Logo' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048'
        ];
    }

    // Validation rules for UPDATE
    public static function updateRules($id)
    {
        return [
            'Org_Name' => 'sometimes|required|string|max:255',
            'Org_Code' => 'sometimes|required|string|max:25|unique:organisation_settings,Org_Code,' . $id . ',Org_Id',
            'Org_GST_No' => 'nullable|string|max:50|unique:organisation_settings,Org_GST_No,' . $id . ',Org_Id',
            'Org_TDS_No' => 'nullable|string|max:50',
            'Org_PAN_No' => 'nullable|string|max:50|unique:organisation_settings,Org_PAN_No,' . $id . ',Org_Id',
            'Org_Address' => 'nullable|string',
            'Org_City' => 'nullable|string|max:100',
            'Org_State' => 'nullable|string|max:100',
            'Org_Pin' => 'nullable|string|max:10',
            'Org_Email' => 'nullable|email|max:100',
            'Org_Mobile' => 'nullable|string|max:20',
            'Org_URL' => 'nullable|url|max:255',
            'Org_Logo' => 'nullable|string' // base64 for update
        ];
    }
}
