<?php
// app/Models/PayBandMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayBandMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'pay_band_id';

    protected $fillable = [
        'commission_id',
        'pay_band_code',
        'min_pay',
        'max_pay'
    ];

    protected $casts = [
        'min_pay' => 'decimal:2',
        'max_pay' => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'commission_id');
    }
}
