<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    protected $table = 'permissions';

    protected $fillable = [
        'id',
        'name',
        'display_name',
        'description',
        'module_id',
        'is_custom',
        'allowed_permissions'
    ];

    protected $casts = [
        'is_custom' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'allowed_permissions' => 'array'
    ];

    public function module()
    {
        return $this->belongsTo(Module::class, 'module_id');
    }

    public function roles()
    {
        return $this->belongsToMany(RoleMaster::class, 'permission_role', 'permission_id', 'role_id')
                    ->withPivot('permission_type_id');
    }

    public function permissionTypes()
    {
        return $this->belongsToMany(PermissionType::class, 'permission_role', 'permission_id', 'permission_type_id')
                    ->withPivot('role_id');
    }
}
