<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RelationshipMaster extends Model
{
    use HasFactory;

    // Specify the table name
    protected $table = 'relationship_master';

    // Specify the primary key
    protected $primaryKey = 'relation_id';

    // Disable auto-incrementing for the primary key since PostgreSQL SERIAL handles it
    public $incrementing = true;

    // Specify the key type
    protected $keyType = 'int';

    // Disable timestamp columns if you don't have them
    public $timestamps = true;

    // Define fillable fields
    protected $fillable = [
        'relation_code',
        'relation_name',
    ];

    // Define casts
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function familyMembers()
{
    return $this->hasMany(FamilyInfoMaster::class, 'relation_id', 'relation_id');
}
}
