<?php

// app/Models/RolePermission.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RolePermission extends Model
{
    use HasFactory;

    protected $table = 'role_permissions';

    protected $fillable = [
        'role_id',
        'func_id',
        'actions',
    ];

    protected $casts = [
        'role_id' => 'integer',
        'func_id' => 'integer',
        'actions' => 'array', // JSON → array
    ];

    // 🔗 Relationships
    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'role_id', 'Role_Id');
    }

    public function functionType()
    {
        return $this->belongsTo(FunctionType::class, 'func_id', 'id');
    }
}
