<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchemeMaster extends Model
{
    use HasFactory;

    protected $table = 'scheme_master';
    protected $primaryKey = 'scheme_id';

    protected $fillable = [
        'scheme_code',
        'scheme_name',
        'department_id',
        'start_date',
        'end_date',
        'budget',
        'status',
        'is_active'
    ];

    // Relationship with MainDepartment
    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'department_id', 'id');
    }
}
