<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    use HasFactory;

    protected $table = 'sub_categories';
    protected $primaryKey = 'sub_category_id';
    public $timestamps = true;

    protected $fillable = [
        'category_id',
        'sub_category_name',
        'sub_category_code',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationship with Category
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'category_id');
    }

    // Relationship with SubSubCategories
    public function subSubCategories()
    {
        return $this->hasMany(SubSubCategory::class, 'sub_category_id', 'sub_category_id');
    }
}
