<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use App\Models\SubLedgMaster;
use App\Models\TendorAllocation;


class TenderPenelty extends Model
{
    protected $table = 'tender_penelty';
    protected $primaryKey = 'tp_id';

    protected $fillable = [
        'SL_Id',
        'Tend_Alloc',
        'Date',
        'fix_per',
        'Gross_Amount',
        'percentage',
        'p_amount',
        'Bill_No',
        'Add_Deduct'
    ];

    // 🔹 Sub Ledger relation
    public function subLedger()
    {
        return $this->belongsTo(SubLedgerMaster::class, 'SL_Id', 'SL_Id');
    }

    // 🔹 Tender Allocation relation
    public function tenderAllocation()
    {
        return $this->belongsTo(TendorAllocation::class, 'Tend_Alloc', 'Tend_Alloc');
    }
}
