<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\GmcUser;
use App\Models\MainDepartment;

class UserDepartmentMapping extends Model
{
    protected $table = 'user_department_mappings';
    protected $primaryKey = 'User_Dept_map_Id';
     public $incrementing = true;      // ✅ ADD THIS
    protected $keyType = 'int';

    protected $fillable = [
        'user_id',
        'Dept_Id',
        'Status'
    ];

    public function user()
    {
        return $this->belongsTo(GmcUser::class, 'user_id', 'user_id');
    }

    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'Dept_Id', 'id');
    }
}
