<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class PermissionRole extends Pivot
{
    protected $table = 'permission_role';

    protected $fillable = [
        'permission_id',
        'role_id',
        'permission_type_id'
    ];

    protected $casts = [
        'permission_id' => 'integer',
        'role_id' => 'integer',
        'permission_type_id' => 'integer'
    ];

    public $incrementing = false;
    public $timestamps = false;

    /**
     * Relationship with Permission model
     */
    public function permission()
    {
        return $this->belongsTo(Permission::class);
    }

    /**
     * Relationship with Role model
     */
    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'role_id', 'Role_Id');
    }

    /**
     * Relationship with PermissionType model
     */
    public function permissionType()
    {
        return $this->belongsTo(PermissionType::class, 'permission_type_id');
    }
}