<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('prty_masts', function (Blueprint $table) {
            $table->id('Pr_Id'); // Auto-incrementing primary key
            $table->bigInteger('Co_Id')->unsigned(); // Foreign key
            $table->bigInteger('Br_Id')->unsigned(); // Foreign key
            $table->string('pr_code', 15)->nullable();
            $table->string('pr_gr', 8)->nullable();
            $table->string('an_id', 40)->nullable();
            $table->string('pr_ct_id', 40)->nullable();
            $table->string('pr_td_id', 40)->nullable();
            $table->string('pr_fb_id', 40)->nullable();
            $table->string('pr_bk_id', 40)->nullable();
            $table->string('pr_name', 40)->nullable();
            $table->string('pr_ad_pr_no', 7)->nullable();
            $table->string('pr_ad_pr_nm', 20)->nullable();
            $table->string('pr_ad_nr_lm', 20)->nullable();
            $table->string('pr_ad_strt', 20)->nullable();
            $table->string('pr_ar_id', 20)->nullable();
            $table->string('pr_eml', 35)->nullable();
            $table->string('pr_web', 35)->nullable();
            $table->string('pr_ph', 35)->nullable();
            $table->string('pr_cp', 35)->nullable();
            $table->string('pr_ref', 30)->nullable();
            $table->string('pr_hld', 1)->nullable();
            $table->string('pr_rmk', 30)->nullable();
            $table->decimal('pr_cr_l', 18, 2)->nullable();
            $table->decimal('pr_dp', 18, 2)->nullable();
            $table->decimal('pr_cr_d', 18, 0)->nullable();
            $table->decimal('pnl_int', 18, 2)->nullable();
            $table->string('pr_bl_p', 1)->nullable();
            $table->string('pr_rpt', 1)->nullable();
            $table->decimal('cq_clr', 18, 0)->nullable();
            $table->string('pr_st', 35)->nullable();
            $table->string('pr_cst', 35)->nullable();
            $table->string('pr_vat', 35)->nullable();
            $table->string('pr_pa', 35)->nullable();
            $table->string('pr_reg', 35)->nullable();
            $table->string('pr_ecx', 35)->nullable();
            $table->string('pr_ecc', 35)->nullable();
            $table->string('pr_e_ad', 35)->nullable();
            $table->string('pr_e_dv', 35)->nullable();
            $table->string('pr_e_col', 35)->nullable();
            $table->string('pr_e_rng', 35)->nullable();
            $table->string('pr_e_ra1', 35)->nullable();
            $table->string('pr_trn', 20)->nullable();
            $table->string('pr_sub', 1)->nullable();
            $table->string('tallydata', 50)->nullable();
            $table->decimal('sn_func_id', 9, 0)->nullable();
            $table->string('sb_func', 20)->nullable();
            $table->string('pr_bl_t', 1)->nullable();
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->decimal('opb_amt', 18, 2)->nullable();
            $table->decimal('cur_amt', 18, 2)->nullable();

            $table->foreign('Co_Id')->references('Co_Id')->on('co_masters')->onDelete('cascade');
            $table->foreign('Br_Id')->references('Br_Id')->on('branch_ms')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prty_masts');
    }
};
