<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('finan_trns', function (Blueprint $table) {
            $table->id('Ft_Id'); // Auto-incrementing primary key
            $table->bigInteger('Co_Id')->unsigned(); // Foreign key to co_masters
            $table->bigInteger('Br_Id')->unsigned(); // Foreign key to branch_ms
            $table->bigInteger('Pr_Id')->unsigned()->nullable(); // Foreign key to prty_masts
            $table->string('vou_ty', 3);
            $table->integer('vou_id');
            $table->integer('vou_sr');
            $table->integer('vou_ln');
            $table->string('v_mode', 1);
            $table->string('vou_rf', 15)->nullable();
            $table->dateTime('vou_dt')->nullable();
            $table->decimal('inq_id', 18, 0)->nullable();
            $table->string('ag_id', 25)->nullable();
            $table->integer('inst_no')->nullable();
            $table->decimal('agt_amt', 19, 4)->nullable();
            $table->decimal('cr_amt', 12, 2)->nullable();
            $table->decimal('dr_amt', 12, 2)->nullable();
            $table->decimal('ref_id', 18, 0)->nullable();
            $table->string('chq_no', 50)->nullable();
            $table->dateTime('chq_dt')->nullable();
            $table->dateTime('clr_dt')->nullable();
            $table->integer('bk_id')->nullable();
            $table->decimal('lot_no', 18, 0)->nullable();
            $table->string('rmk1', 150)->nullable();
            $table->string('rmk2', 150)->nullable();
            $table->string('rmk3', 150)->nullable();
            $table->string('rmk4', 150)->nullable();
            $table->string('rmk5', 150)->nullable();
            $table->string('chq_mode', 1)->nullable();
            $table->string('r_mode', 2)->nullable();
            $table->string('sms_stus', 1)->nullable();
            $table->string('email_stus', 1)->nullable();
            $table->integer('sm_id')->nullable();
            $table->string('an_id', 40)->nullable();
            $table->string('bfr1', 50)->nullable();
            $table->string('bfr2', 50)->nullable();
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->string('pay_mode', 5)->nullable();
            $table->integer('exp_ref')->nullable();

            $table->foreign('Co_Id')->references('Co_Id')->on('co_masters')->onDelete('cascade');
            $table->foreign('Br_Id')->references('Br_Id')->on('branch_ms')->onDelete('cascade');
            $table->foreign('Pr_Id')->references('Pr_Id')->on('prty_masts')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finan_trns');
    }
};
