<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sub_sub_categories', function (Blueprint $table) {
            $table->bigIncrements('sub_sub_category_id');
            $table->bigInteger('sub_category_id')->unsigned(); // Foreign key to co_masters
            $table->string('sub_sub_category_name', 100);
            $table->string('sub_sub_category_code', 50);
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Unique constraint for combination of sub_category_id and sub_sub_category_code
            $table->unique(['sub_category_id', 'sub_sub_category_code']);
            $table->foreign('sub_category_id')->references('sub_category_id')->on('sub_categories')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sub_sub_categories');
    }
};
