<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gmc_user_sessions', function (Blueprint $table) {
            $table->id('session_id');
            $table->unsignedBigInteger('user_id');
            $table->string('session_token', 255)->unique();
            $table->ipAddress('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->string('device_info', 255)->nullable();
            $table->timestamp('login_time')->useCurrent();
            $table->timestamp('last_activity')->useCurrent();

            // FIXED: Added default value for expires_at
            $table->timestamp('expires_at')->useCurrent();

            $table->boolean('is_active')->default(true);

            // Foreign Key
            $table->foreign('user_id')->references('user_id')->on('gmc_users')->onDelete('cascade');

            // Indexes
            $table->index('user_id');
            $table->index('session_token');
            $table->index('expires_at');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gmc_user_sessions');
    }
};
