<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gmc_user_audit_log', function (Blueprint $table) {
            $table->id('audit_id');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('action_type', 50);
            $table->text('action_details');
            $table->ipAddress('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamp('performed_at')->useCurrent();

            // Foreign Key
            $table->foreign('user_id')->references('user_id')->on('gmc_users')->onDelete('set null');

            // Indexes
            $table->index('user_id');
            $table->index('action_type');
            $table->index('performed_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gmc_user_audit_log');
    }
};
