<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gmc_device_registration_queue', function (Blueprint $table) {
            $table->id('queue_id');

            // User Reference
            $table->unsignedBigInteger('user_id');

            // Registration Data (Stored as JSON for flexibility)
            $table->json('registration_data'); // username, email, mobile, Role_Id etc

            // Auto-Captured Device Information
            $table->string('ip_address', 45);
            $table->string('mac_address', 50)->nullable();
            $table->string('hdd_serial', 100)->nullable();
            $table->string('motherboard_serial', 100)->nullable();
            $table->string('processor_id', 100)->nullable();
            $table->string('browser_fingerprint', 255);
            $table->string('operating_system', 100);
            $table->string('browser', 100);
            $table->string('device_name', 100);
            $table->enum('device_type', ['DESKTOP', 'LAPTOP', 'MOBILE', 'TABLET', 'OTHER'])->default('DESKTOP');

            // Location & Department
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('location_id')->nullable();

            // Status & Processing
            $table->enum('status', ['PENDING', 'APPROVED', 'REJECTED', 'EXPIRED'])->default('PENDING');
            $table->text('rejection_reason')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->unsignedBigInteger('processed_by')->nullable();

            // Citizen Check
            $table->boolean('is_citizen')->default(false);

            // Timestamps
            $table->timestamp('submitted_at')->useCurrent();
            $table->timestamps();

            // Foreign Keys
            $table->foreign('user_id')->references('user_id')->on('gmc_users')->onDelete('cascade');
            $table->foreign('processed_by')->references('user_id')->on('gmc_users')->onDelete('set null');
            $table->foreign('department_id')->references('department_id')->on('departments')->onDelete('set null');

            // Indexes
            $table->index(['user_id', 'status']);
            $table->index('submitted_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gmc_device_registration_queue');
    }
};
