<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gmc_device_approval_logs', function (Blueprint $table) {
            $table->id('log_id');

            // References
            $table->unsignedBigInteger('queue_id')->nullable();
            $table->unsignedBigInteger('approval_id')->nullable();
            $table->unsignedBigInteger('user_id');

            // Action Details
            $table->enum('action_type', [
                'REGISTRATION_SUBMITTED',
                'APPROVAL_REQUESTED',
                'APPROVED',
                'REJECTED',
                'AUTO_APPROVED_CITIZEN',
                'EXPIRED',
                'RENEWED'
            ]);

            $table->text('action_details');
            $table->json('device_data')->nullable();

            // Performed By
            $table->unsignedBigInteger('performed_by')->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->string('user_agent', 255)->nullable();

            // Timestamps
            $table->timestamp('performed_at')->useCurrent();

            // Foreign Keys
            $table->foreign('queue_id')->references('queue_id')->on('gmc_device_registration_queue')->onDelete('set null');
            $table->foreign('approval_id')->references('approval_id')->on('gmc_device_approvals')->onDelete('set null');
            $table->foreign('user_id')->references('user_id')->on('gmc_users')->onDelete('cascade');
            $table->foreign('performed_by')->references('user_id')->on('gmc_users')->onDelete('set null');

            // Indexes
            $table->index(['user_id', 'performed_at']);
            $table->index('action_type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gmc_device_approval_logs');
    }
};
