<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('fas_debt_type_master', function (Blueprint $table) {
            $table->id('debt_type_id');
            $table->string('debt_code', 20)->unique();
            $table->string('debt_name', 100);
            $table->decimal('interest_rate', 5, 2)->nullable();
            $table->integer('repayment_years')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps(); // This adds both created_at and updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('fas_debt_type_master');
    }
};
