<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('fas_loan_type_master', function (Blueprint $table) {
            $table->id('loan_type_id');
            $table->string('loan_code', 20)->unique();
            $table->string('loan_name', 100);
            $table->decimal('max_amount', 15, 2)->nullable();
            $table->string('loan_mode', 10)->nullable()->comment('IN/OUT');
            $table->decimal('interest_rate', 5, 2)->nullable();
            $table->integer('tenure_years')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('fas_loan_type_master');
    }
};
