<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('function_types', function (Blueprint $table) {
            $table->id();
            $table->string('desc')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->string('Upgrp')->nullable();
            $table->string('Grcod')->nullable();
            $table->string('Grsrn')->nullable();
            $table->string('Grsh')->nullable();
            $table->timestamps();

            $table->foreign('category_id')->references('category_id')->on('categories')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('function_types');
    }
};
