<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('organisation_settings', function (Blueprint $table) {
            $table->bigIncrements('Org_Id');
            $table->string('Org_Name', 25);
            $table->string('Org_Code', 25);
            $table->string('Org_GST_No', 50)->nullable();
            $table->string('Org_TDS_No', 50)->nullable();
            $table->string('Org_PAN_No', 50)->nullable();
            $table->text('Org_Address')->nullable();
            $table->string('Org_City', 100)->nullable();
            $table->string('Org_State', 100)->nullable();
            $table->string('Org_Pin', 10)->nullable();
            $table->string('Org_Email', 100)->nullable();
            $table->string('Org_Mobile', 20)->nullable();
            $table->string('Org_URL', 255)->nullable();
            $table->string('Org_Logo', 255)->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Add unique constraints
            $table->unique('Org_Code');
            $table->unique('Org_GST_No')->whereNotNull('Org_GST_No');
            $table->unique('Org_PAN_No')->whereNotNull('Org_PAN_No');
        });
    }

    public function down()
    {
        Schema::dropIfExists('organisation_settings');
    }
};
