<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('organisation_fin_years', function (Blueprint $table) {
            $table->bigIncrements('Org_FYID');
            $table->string('Org_Id', 25);
            $table->string('Fin_Year', 25);
            $table->date('Fin_St_Dt');
            $table->date('Fin_Ed_Dt');
            $table->enum('Fin_Status', ['Active', 'Inactive', 'Closed'])->default('Active');
            $table->timestamps();
            $table->softDeletes();

            // Add foreign key constraint if Org_Id references organisation_settings
            // $table->foreign('Org_Id')->references('Org_Code')->on('organisation_settings')->onDelete('cascade');

            // Add unique constraint for Org_Id and Fin_Year combination
            $table->unique(['Org_Id', 'Fin_Year']);

            // Add index for better performance
            $table->index('Fin_Status');
            $table->index(['Fin_St_Dt', 'Fin_Ed_Dt']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('organisation_fin_years');
    }
};
