<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('zone_masters', function (Blueprint $table) {
            $table->bigIncrements('Zone_Id');
            $table->string('Zone_Code', 5);
            $table->string('Zone_Name', 25);
            $table->unsignedBigInteger('Org_Id')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Add foreign key constraint
            $table->foreign('Org_Id')
                  ->references('Org_Id')
                  ->on('organisation_settings')
                  ->onDelete('set null');

            // Add unique constraint for Zone_Code within same organization
            // For NULL Org_Id, allow multiple records with same Zone_Code
            $table->unique(['Zone_Code', 'Org_Id']);

            // Add indexes for better performance
            $table->index('Zone_Code');
            $table->index('Zone_Name');
            $table->index('Org_Id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('zone_masters');
    }
};
