<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('SubLedg_Master', function (Blueprint $table) {
            $table->id('SL_Id');
            $table->foreignId('Lg_ID')->constrained('Ledger_Master', 'Lg_Id')->onDelete('cascade');
            $table->string('SL_Code', 50)->unique();
            $table->string('SL_Name', 200);
            $table->text('SL_Address')->nullable();
            $table->string('SL_City', 100)->nullable();
            $table->string('SL_Pin', 20)->nullable();
            $table->string('SL_Phone', 20)->nullable();
            $table->string('SL_Email', 100)->nullable();
            $table->string('SL_Cont_Pers', 100)->nullable()->comment('Contact Person Name');
            $table->decimal('SL_Cr_Lim', 15, 2)->default(0.00);
            $table->decimal('SL_Draw_Pwr', 15, 2)->default(0.00);
            $table->boolean('SL_Status')->default(true)->comment('0=Inactive, 1=Active');
            $table->timestamps();

            // Indexes
            $table->index('Lg_ID');
            $table->index('SL_Code');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('SubLedg_Master');
    }
};
